<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Specialization extends Model 
{

    protected $table = 'specializations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function admin()
    {
        return $this->belongsTo('App\Models\Admin');
    }

    public function users()
    {
        return $this->belongsToMany('App\Models\User');
    }

    public function media()
    {
        return $this->hasOne('App\Models\Media');
    }

}